\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{saip}[2025/06/24 SAIP LaTeX template]

\LoadClass[a4paper,oneside]{article}

% Geometry (user-specified)
\RequirePackage[top=40mm,bottom=27mm,left=25mm,right=25mm]{geometry}

% Fonts to match Word styling
\RequirePackage{helvet}          % Title/headings
\RequirePackage{times}           % Main text
\RequirePackage{courierten}   % Monospaced text

\DeclareFontShape{OT1}{cmr}{m}{n}{
  <-6> cmr5
  <6-7> cmr6
  <7-8> cmr7
  <8-9> cmr8
  <9-10> cmr9
  <10-12> cmr10
  <12-17> cmr12
  <17-> cmr17
}{}

\DeclareFontShape{OML}{cmm}{m}{it}{
  <-6> cmmi5
  <6-7> cmmi6
  <7-8> cmmi7
  <8-9> cmmi8
  <9-10> cmmi9
  <10-12> cmmi10
  <12-17> cmmi12
  <17-> cmmi12
}{}

\DeclareFontShape{OMS}{cmsy}{m}{n}{
  <-6> cmsy5
  <6-7> cmsy6
  <7-8> cmsy7
  <8-9> cmsy8
  <9-10> cmsy9
  <10-12> cmsy10
  <12-17> cmsy10
  <17-> cmsy10
}{}


% Margin settings
%\setlength{\hoffset}{0mm}
%\setlength{\marginparsep}{0mm}
%\setlength{\marginparwidth}{0mm}
%\setlength{\textwidth}{160mm}
%\setlength{\oddsidemargin}{-0.4mm}
%\setlength{\evensidemargin}{-0.4mm}
%\setlength{\voffset}{0mm}
%\setlength{\headheight}{8mm}
%\setlength{\headsep}{5mm}
%\setlength{\footskip}{0mm}
%\setlength{\textheight}{230mm}
%\setlength{\topmargin}{1.6mm}

% More length definitions
\setlength\maxdepth{.5\topskip}
\setlength\@maxdepth\maxdepth
\setlength\footnotesep{8.4\p@}
\setlength{\skip\footins} {10.8\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep       {14\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\textfloatsep   {24\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep      {16\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\dblfloatsep    {16\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\dbltextfloatsep{24\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@}
\setlength\@fpsep{10\p@ \@plus 1fil}
\setlength\@fpbot{0\p@}
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{10\p@ \@plus 1fil}
\setlength\@dblfpbot{0\p@}
\setlength\partopsep{3\p@ \@plus 2\p@ \@minus 2\p@}



% common abbrevitions for various journals in physics, taken from aa.cls, found at:
% https://www.aanda.org/for-authors/latex-issues/texnical-background-information

\newcommand*\aap{A\&A}
\let\astap=\aap
\newcommand*\aapr{A\&A~Rev.}
\newcommand*\aaps{A\&AS}
\newcommand*\actaa{Acta Astron.}
\newcommand*\aj{AJ}
\newcommand*\ao{Appl.~Opt.}
\let\applopt\ao
\newcommand*\apj{ApJ}
\newcommand*\apjl{ApJ}
\let\apjlett\apjl
\newcommand*\apjs{ApJS}
\let\apjsupp\apjs
\newcommand*\aplett{Astrophys.~Lett.}
\newcommand*\apspr{Astrophys.~Space~Phys.~Res.}
\newcommand*\apss{Ap\&SS}
\newcommand*\araa{ARA\&A}
\newcommand*\azh{AZh}
\newcommand*\baas{BAAS}
\newcommand*\bac{Bull. astr. Inst. Czechosl.}
\newcommand*\bain{Bull.~Astron.~Inst.~Netherlands}
\newcommand*\caa{Chinese Astron. Astrophys.}
\newcommand*\cjaa{Chinese J. Astron. Astrophys.}
\newcommand*\fcp{Fund.~Cosmic~Phys.}
\newcommand*\gca{Geochim.~Cosmochim.~Acta}
\newcommand*\grl{Geophys.~Res.~Lett.}
\newcommand*\iaucirc{IAU~Circ.}
\newcommand*\icarus{Icarus}
\newcommand*\jcap{J. Cosmology Astropart. Phys.}
\newcommand*\jcp{J.~Chem.~Phys.}
\newcommand*\jgr{J.~Geophys.~Res.}
\newcommand*\jqsrt{J.~Quant.~Spectr.~Rad.~Transf.}
\newcommand*\jrasc{JRASC}
\newcommand*\memras{MmRAS}
\newcommand*\memsai{Mem.~Soc.~Astron.~Italiana}
\newcommand*\mnras{MNRAS}
\newcommand*\na{New A}
\newcommand*\nar{New A Rev.}
\newcommand*\nat{Nature}
\newcommand*\nphysa{Nucl.~Phys.~A}
\newcommand*\pasa{PASA}
\newcommand*\pasj{PASJ}
\newcommand*\pasp{PASP}
\newcommand*\physrep{Phys.~Rep.}
\newcommand*\physscr{Phys.~Scr}
\newcommand*\planss{Planet.~Space~Sci.}
\newcommand*\pra{Phys.~Rev.~A}
\newcommand*\prb{Phys.~Rev.~B}
\newcommand*\prc{Phys.~Rev.~C}
\newcommand*\prd{Phys.~Rev.~D}
\newcommand*\pre{Phys.~Rev.~E}
\newcommand*\prl{Phys.~Rev.~Lett.}
\newcommand*\procspie{Proc.~SPIE}
\newcommand*\qjras{QJRAS}
\newcommand*\rmxaa{Rev. Mexicana Astron. Astrofis.}
\newcommand*\skytel{S\&T}
\newcommand*\solphys{Sol.~Phys.}
\newcommand*\sovast{Soviet~Ast.}
\newcommand*\ssr{Space~Sci.~Rev.}
\newcommand*\zap{ZAp}



% Set indent for front matter
\renewenvironment{quote}%
  {\list{}{\leftmargin=25mm}\item\relax}%
  {\endlist}

% Clear the header and footer

\pagestyle{empty}

% Styles for front matter

\renewcommand{\title}[1]{\vspace*{25mm}{\exhyphenpenalty=10000\hyphenpenalty=10000 
 \fontsize{18}{24}\selectfont\bf\noindent\raggedright
        \textsf{#1}\par}}

		
\renewcommand{\author}[1]{\vspace*{1.5pc}%
   \fontsize{11}{13}
       \begin{quote}\raggedright \textbf{#1}\end{quote}}

\newcommand{\affil}[1]{\fontsize{10}{11}\selectfont
       \begin{quote}\raggedright #1\end{quote}
	   \vspace*{-22pt}}

\newcommand{\email}[1]{\vspace*{12pt}\fontsize{10}{11}\selectfont
       \begin{quote}\raggedright E-mail: #1\end{quote}
	   \vspace*{-22pt}}

\renewenvironment{abstract}{%
      \vspace{16pt plus3pt minus3pt}
      \begin{quote}
      \bfseries \abstractname.\quad\rm\ignorespaces} 
      {\end{quote}\vspace{5mm}}

% Section titles
	
\renewcommand\section{\@startsection {section}{1}{\z@}%
                   {-3.25ex\@plus -1ex \@minus -.2ex}%
                   {1sp}%
                   {\reset@font\normalsize\bfseries\raggedright}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                   {-3.25ex\@plus -1ex \@minus -.2ex}%
                   {1sp}%
                   {\reset@font\normalsize\itshape\raggedright}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {-1em \@plus .2em}%
                                     {\reset@font\normalsize\itshape}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\reset@font\normalsize\itshape}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\reset@font\normalsize\itshape}}
			



\endinput